# CRITICAL: How to Fix Chrome Extension Cache Issue

## The Problem
Chrome is loading OLD CACHED versions of the HTML files that still have CDN script tags.
Even though we updated the files, Chrome hasn't reloaded them.

## THE SOLUTION - DO THIS NOW:

### Step 1: Clear Extension Cache
1. Go to `chrome://extensions/`
2. Find "Trader Emotion Tracker"
3. Click **"Remove"** button (yes, remove it completely)
4. Confirm removal

### Step 2: Reinstall Extension
1. Still on `chrome://extensions/`
2. Enable **"Developer mode"** (top right toggle)
3. Click **"Load unpacked"**
4. Navigate to: `C:\Users\ben\CascadeProjects\2048\emotion-tracker\chrome-extension`
5. Click **"Select Folder"**

### Step 3: Test
1. Click the extension icon
2. Click "Open Full Tracker"
3. Press **F12** to open console
4. You should see:
   ```
   === EXTENSION LOADED ===
   Chart.js loaded: true
   TensorFlow.js loaded: true
   BlazeFace loaded: true
   ```

## Why This Happens
Chrome aggressively caches extension files. Simply clicking "Reload" doesn't always clear the cache.
Removing and reinstalling forces Chrome to load fresh files.

## What Should Work After This
- ✅ No CDN errors
- ✅ TensorFlow.js loads from local libs/tf.min.js
- ✅ BlazeFace loads from local libs/blazeface.js
- ✅ Chart.js loads from local libs/chart.min.js
- ✅ Face detection works
- ✅ Green boxes appear on your face
- ✅ Emotions update in real-time

## If Still Not Working
Close ALL Chrome tabs with the extension open, then try again.
Chrome sometimes keeps old versions in memory even after reload.
