# ZenTrader Chrome Extension

**Stay Calm. Trade Smart.**

AI-powered emotion tracking for disciplined trading.

## Features

- 🎯 **Real-time Face Tracking** - Uses TensorFlow.js and BlazeFace for accurate face detection
- 🧠 **Emotion Analysis** - Tracks Stress, Excitement, Focus, and Positive emotions
- 📊 **Live Graphs** - 60-second emotion history visualization
- 🚦 **Trading Zone Indicators** - Optimal/Caution/Danger zones for trading discipline
- 📈 **Session Statistics** - Track your emotional patterns over time
- ⚠️ **Alert System** - Get notified when entering danger zones
- 🧘 **Mindful Guidance** - Supportive, awareness-based recommendations

## Installation

### From Source (Developer Mode)

1. Download or clone this repository
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable **Developer mode** (toggle in top-right corner)
4. Click **"Load unpacked"**
5. Select the `chrome-extension` folder
6. The extension icon will appear in your toolbar

### From Chrome Web Store

Coming soon!

## Usage

### Mini View (Popup)

1. Click the extension icon in your Chrome toolbar
2. View quick emotion status and current trading zone
3. See session time and emotional state
4. Click **"Open Full Tracker"** for complete interface

### Full Tracker Interface

1. Click "Open Full Tracker" from popup, or
2. Right-click extension icon → Open full page
3. **Allow camera access** when prompted (required for face tracking)
4. The tracker will automatically start analyzing your emotions

### Interface Overview

**Full Tracker includes:**
- 📹 Live video feed with face detection overlay
- 🧠 Real-time emotion bars (Stress, Excitement, Focus, Positive)
- 📊 60-second emotion history graph
- 🚦 Trading zone indicator (changes color based on your state)
- 💡 Contextual guidance messages
- 📈 Session statistics (averages, peaks, time in optimal zone)
- ⚠️ Alert history
- 🧘 Powered by Claude AI

## How It Works

### Emotion Detection

The extension uses **TensorFlow.js** with the **BlazeFace** model to detect your face in real-time. It analyzes:

1. **Movement** - Jittery movements indicate stress
2. **Face Size** - Leaning in indicates excitement/engagement
3. **Stability** - Stillness indicates focus
4. **Overall Calmness** - Contributes to positive emotion score

### Trading Zones

- **🟢 OPTIMAL** - Low stress (<45%), low excitement (<45%), good focus (>40%)
- **🟡 CAUTION** - Moderate stress (45-70%) or excitement (45-70%)
- **🔴 DANGER** - High stress (>70%), high excitement (>70%), or very low focus (<25%)

### Emotional States

- **🎯 FOCUSED** - High stress + high focus (concentrated, not anxious)
- **⚠️ STRESSED** - High stress + low focus (anxious, distracted)
- **✓ NEUTRAL** - Balanced emotional state

## Privacy & Security

- ✅ **100% Local Processing** - All emotion analysis happens in your browser
- ✅ **No Data Sent to Servers** - Your video never leaves your computer
- ✅ **No Storage** - Video is processed in real-time and not saved
- ✅ **Camera Only** - Used exclusively for emotion detection

## Requirements

- Chrome browser (version 88+)
- Webcam/camera access
- Internet connection (for loading TensorFlow.js and Chart.js from CDN)

## Troubleshooting

### Camera Not Working

1. Check that you've allowed camera permissions
2. Go to `chrome://settings/content/camera`
3. Ensure the extension has camera access
4. Try reloading the extension

### Face Not Detected

1. Ensure good lighting
2. Face the camera directly
3. Remove glasses if detection is poor
4. Adjust camera angle

### Extension Not Loading

1. Check that you're using Chrome 88+
2. Disable other extensions that might conflict
3. Reload the extension from `chrome://extensions/`
4. Check browser console for errors (F12)

## Technical Stack

- **TensorFlow.js** - Machine learning framework
- **BlazeFace** - Face detection model
- **Chart.js** - Emotion history visualization
- **Chrome Extension Manifest V3** - Latest extension format
- **Vanilla JavaScript** - No framework dependencies

## Development

### Project Structure

```
chrome-extension/
├── manifest.json          # Extension configuration
├── popup.html/js/css      # Mini popup interface
├── fullpage.html/js/css   # Full tracker interface
├── tracker.js             # Face detection & emotion logic
├── styles.css             # Shared styles
├── icons/                 # Extension icons
└── README.md              # This file
```

### Local Development

1. Make changes to the source files
2. Go to `chrome://extensions/`
3. Click the refresh icon on the extension card
4. Test your changes

## Credits

**Powered by Claude AI**

Built with mindfulness and care for the trading community.

- TensorFlow.js for machine learning
- BlazeFace for face detection
- Chart.js for visualization

## License

MIT License

## Support

For issues or questions, please contact the development team.

---

**Remember:** This tool is designed to help you maintain emotional discipline while trading. It's not a substitute for proper risk management, trading strategy, or professional advice.

Trade responsibly. 🚀
